import { BaseSeparator_default } from "../component/BaseSeparator.js";
import { createBlock, defineComponent, guardReactiveProps, normalizeProps, openBlock, renderSlot, withCtx } from "vue";

//#region src/Separator/Separator.vue?vue&type=script&setup=true&lang.ts
var Separator_vue_vue_type_script_setup_true_lang_default = /* @__PURE__ */ defineComponent({
	__name: "Separator",
	props: {
		orientation: {
			type: String,
			required: false,
			default: "horizontal"
		},
		decorative: {
			type: Boolean,
			required: false
		},
		asChild: {
			type: Boolean,
			required: false
		},
		as: {
			type: null,
			required: false
		}
	},
	setup(__props) {
		const props = __props;
		return (_ctx, _cache) => {
			return openBlock(), createBlock(BaseSeparator_default, normalizeProps(guardReactiveProps(props)), {
				default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
				_: 3
			}, 16);
		};
	}
});

//#endregion
//#region src/Separator/Separator.vue
var Separator_default = Separator_vue_vue_type_script_setup_true_lang_default;

//#endregion
export { Separator_default };
//# sourceMappingURL=Separator.js.map