import { useForwardExpose } from "../shared/useForwardExpose.js";
import { PopperArrow_default } from "../Popper/PopperArrow.js";
import { createBlock, defineComponent, guardReactiveProps, normalizeProps, openBlock, renderSlot, unref, withCtx } from "vue";

//#region src/HoverCard/HoverCardArrow.vue?vue&type=script&setup=true&lang.ts
var HoverCardArrow_vue_vue_type_script_setup_true_lang_default = /* @__PURE__ */ defineComponent({
	__name: "HoverCardArrow",
	props: {
		width: {
			type: Number,
			required: false,
			default: 10
		},
		height: {
			type: Number,
			required: false,
			default: 5
		},
		rounded: {
			type: Boolean,
			required: false
		},
		asChild: {
			type: Boolean,
			required: false
		},
		as: {
			type: null,
			required: false,
			default: "svg"
		}
	},
	setup(__props) {
		const props = __props;
		useForwardExpose();
		return (_ctx, _cache) => {
			return openBlock(), createBlock(unref(PopperArrow_default), normalizeProps(guardReactiveProps(props)), {
				default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
				_: 3
			}, 16);
		};
	}
});

//#endregion
//#region src/HoverCard/HoverCardArrow.vue
var HoverCardArrow_default = HoverCardArrow_vue_vue_type_script_setup_true_lang_default;

//#endregion
export { HoverCardArrow_default };
//# sourceMappingURL=HoverCardArrow.js.map