import { useForwardExpose } from "../shared/useForwardExpose.js";
import { DialogTrigger_default } from "../Dialog/DialogTrigger.js";
import { createBlock, defineComponent, guardReactiveProps, normalizeProps, openBlock, renderSlot, unref, withCtx } from "vue";

//#region src/AlertDialog/AlertDialogTrigger.vue?vue&type=script&setup=true&lang.ts
var AlertDialogTrigger_vue_vue_type_script_setup_true_lang_default = /* @__PURE__ */ defineComponent({
	__name: "AlertDialogTrigger",
	props: {
		asChild: {
			type: Boolean,
			required: false
		},
		as: {
			type: null,
			required: false,
			default: "button"
		}
	},
	setup(__props) {
		const props = __props;
		useForwardExpose();
		return (_ctx, _cache) => {
			return openBlock(), createBlock(unref(DialogTrigger_default), normalizeProps(guardReactiveProps(props)), {
				default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
				_: 3
			}, 16);
		};
	}
});

//#endregion
//#region src/AlertDialog/AlertDialogTrigger.vue
var AlertDialogTrigger_default = AlertDialogTrigger_vue_vue_type_script_setup_true_lang_default;

//#endregion
export { AlertDialogTrigger_default };
//# sourceMappingURL=AlertDialogTrigger.js.map