import { u as useToast, _ as _sfc_main$5, a as _sfc_main$3, b as _sfc_main$7, c as _sfc_main$1$1, d as _sfc_main$6, e as _sfc_main$2$1, f as _sfc_main$4 } from './useToast-lA8fNhE4.mjs';
import { useForm, Field } from 'vee-validate';
import { _ as _sfc_main$8 } from './index-fMaJOBB-.mjs';
import { defineComponent, mergeProps, withCtx, createTextVNode, createVNode, resolveDynamicComponent, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrRenderVNode, ssrInterpolate } from 'vue/server-renderer';
import { toTypedSchema } from '@vee-validate/zod';
import * as z from 'zod';
import { MapPin, Mail, Phone, Clock } from 'lucide-vue-next';

const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  __name: "form",
  __ssrInlineRender: true,
  setup(__props) {
    const { success } = useToast();
    const formSchema = toTypedSchema(
      z.object({
        firstName: z.string().min(2).max(50),
        lastName: z.string().min(2).max(50),
        email: z.email(),
        company: z.string().min(2).max(50).optional(),
        message: z.string().min(10).max(500)
      })
    );
    const { handleSubmit } = useForm({
      validationSchema: formSchema
    });
    handleSubmit((values) => {
      success("Form submitted");
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_FormField = Field;
      const _component_FormItem = _sfc_main$5;
      const _component_FormLabel = _sfc_main$3;
      const _component_FormControl = _sfc_main$7;
      const _component_Input = _sfc_main$1$1;
      const _component_FormDescription = _sfc_main$6;
      const _component_FormMessage = _sfc_main$2$1;
      const _component_Textarea = _sfc_main$4;
      const _component_Button = _sfc_main$8;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "bg-white rounded-2xl p-8 shadow-soft" }, _attrs))}><h3 class="font-playfair text-2xl font-semibold text-foreground mb-6"> Send us a Message </h3><form class="space-y-6"><div class="grid grid-cols-1 sm:grid-cols-2 gap-4">`);
      _push(ssrRenderComponent(_component_FormField, { name: "firstName" }, {
        default: withCtx(({ componentField }, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_FormItem, null, {
              default: withCtx((_, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_FormLabel, null, {
                    default: withCtx((_2, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(` First Name*`);
                      } else {
                        return [
                          createTextVNode(" First Name*")
                        ];
                      }
                    }),
                    _: 2
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormControl, null, {
                    default: withCtx((_2, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_Input, mergeProps(componentField, { placeholder: "First Name" }), null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_Input, mergeProps(componentField, { placeholder: "First Name" }), null, 16)
                        ];
                      }
                    }),
                    _: 2
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormDescription, null, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormMessage, null, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_FormLabel, null, {
                      default: withCtx(() => [
                        createTextVNode(" First Name*")
                      ]),
                      _: 1
                    }),
                    createVNode(_component_FormControl, null, {
                      default: withCtx(() => [
                        createVNode(_component_Input, mergeProps(componentField, { placeholder: "First Name" }), null, 16)
                      ]),
                      _: 2
                    }, 1024),
                    createVNode(_component_FormDescription),
                    createVNode(_component_FormMessage)
                  ];
                }
              }),
              _: 2
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_FormItem, null, {
                default: withCtx(() => [
                  createVNode(_component_FormLabel, null, {
                    default: withCtx(() => [
                      createTextVNode(" First Name*")
                    ]),
                    _: 1
                  }),
                  createVNode(_component_FormControl, null, {
                    default: withCtx(() => [
                      createVNode(_component_Input, mergeProps(componentField, { placeholder: "First Name" }), null, 16)
                    ]),
                    _: 2
                  }, 1024),
                  createVNode(_component_FormDescription),
                  createVNode(_component_FormMessage)
                ]),
                _: 2
              }, 1024)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_FormField, { name: "lastName" }, {
        default: withCtx(({ componentField }, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_FormItem, null, {
              default: withCtx((_, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_FormLabel, null, {
                    default: withCtx((_2, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(` Last Name*`);
                      } else {
                        return [
                          createTextVNode(" Last Name*")
                        ];
                      }
                    }),
                    _: 2
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormControl, null, {
                    default: withCtx((_2, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_Input, mergeProps(componentField, { placeholder: "Last Name" }), null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_Input, mergeProps(componentField, { placeholder: "Last Name" }), null, 16)
                        ];
                      }
                    }),
                    _: 2
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormDescription, null, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormMessage, null, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_FormLabel, null, {
                      default: withCtx(() => [
                        createTextVNode(" Last Name*")
                      ]),
                      _: 1
                    }),
                    createVNode(_component_FormControl, null, {
                      default: withCtx(() => [
                        createVNode(_component_Input, mergeProps(componentField, { placeholder: "Last Name" }), null, 16)
                      ]),
                      _: 2
                    }, 1024),
                    createVNode(_component_FormDescription),
                    createVNode(_component_FormMessage)
                  ];
                }
              }),
              _: 2
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_FormItem, null, {
                default: withCtx(() => [
                  createVNode(_component_FormLabel, null, {
                    default: withCtx(() => [
                      createTextVNode(" Last Name*")
                    ]),
                    _: 1
                  }),
                  createVNode(_component_FormControl, null, {
                    default: withCtx(() => [
                      createVNode(_component_Input, mergeProps(componentField, { placeholder: "Last Name" }), null, 16)
                    ]),
                    _: 2
                  }, 1024),
                  createVNode(_component_FormDescription),
                  createVNode(_component_FormMessage)
                ]),
                _: 2
              }, 1024)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(_component_FormField, { name: "company" }, {
        default: withCtx(({ componentField }, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_FormItem, null, {
              default: withCtx((_, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_FormLabel, null, {
                    default: withCtx((_2, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(` Company `);
                      } else {
                        return [
                          createTextVNode(" Company ")
                        ];
                      }
                    }),
                    _: 2
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormControl, null, {
                    default: withCtx((_2, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_Input, mergeProps(componentField, { placeholder: "Company" }), null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_Input, mergeProps(componentField, { placeholder: "Company" }), null, 16)
                        ];
                      }
                    }),
                    _: 2
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormDescription, null, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormMessage, null, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_FormLabel, null, {
                      default: withCtx(() => [
                        createTextVNode(" Company ")
                      ]),
                      _: 1
                    }),
                    createVNode(_component_FormControl, null, {
                      default: withCtx(() => [
                        createVNode(_component_Input, mergeProps(componentField, { placeholder: "Company" }), null, 16)
                      ]),
                      _: 2
                    }, 1024),
                    createVNode(_component_FormDescription),
                    createVNode(_component_FormMessage)
                  ];
                }
              }),
              _: 2
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_FormItem, null, {
                default: withCtx(() => [
                  createVNode(_component_FormLabel, null, {
                    default: withCtx(() => [
                      createTextVNode(" Company ")
                    ]),
                    _: 1
                  }),
                  createVNode(_component_FormControl, null, {
                    default: withCtx(() => [
                      createVNode(_component_Input, mergeProps(componentField, { placeholder: "Company" }), null, 16)
                    ]),
                    _: 2
                  }, 1024),
                  createVNode(_component_FormDescription),
                  createVNode(_component_FormMessage)
                ]),
                _: 2
              }, 1024)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_FormField, { name: "email" }, {
        default: withCtx(({ componentField }, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_FormItem, null, {
              default: withCtx((_, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_FormLabel, null, {
                    default: withCtx((_2, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(` Email* `);
                      } else {
                        return [
                          createTextVNode(" Email* ")
                        ];
                      }
                    }),
                    _: 2
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormControl, null, {
                    default: withCtx((_2, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_Input, mergeProps(componentField, { placeholder: "example@gmail.com" }), null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_Input, mergeProps(componentField, { placeholder: "example@gmail.com" }), null, 16)
                        ];
                      }
                    }),
                    _: 2
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormDescription, null, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormMessage, null, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_FormLabel, null, {
                      default: withCtx(() => [
                        createTextVNode(" Email* ")
                      ]),
                      _: 1
                    }),
                    createVNode(_component_FormControl, null, {
                      default: withCtx(() => [
                        createVNode(_component_Input, mergeProps(componentField, { placeholder: "example@gmail.com" }), null, 16)
                      ]),
                      _: 2
                    }, 1024),
                    createVNode(_component_FormDescription),
                    createVNode(_component_FormMessage)
                  ];
                }
              }),
              _: 2
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_FormItem, null, {
                default: withCtx(() => [
                  createVNode(_component_FormLabel, null, {
                    default: withCtx(() => [
                      createTextVNode(" Email* ")
                    ]),
                    _: 1
                  }),
                  createVNode(_component_FormControl, null, {
                    default: withCtx(() => [
                      createVNode(_component_Input, mergeProps(componentField, { placeholder: "example@gmail.com" }), null, 16)
                    ]),
                    _: 2
                  }, 1024),
                  createVNode(_component_FormDescription),
                  createVNode(_component_FormMessage)
                ]),
                _: 2
              }, 1024)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_FormField, { name: "message" }, {
        default: withCtx(({ componentField }, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_FormItem, null, {
              default: withCtx((_, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_FormLabel, null, {
                    default: withCtx((_2, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(` Message* `);
                      } else {
                        return [
                          createTextVNode(" Message* ")
                        ];
                      }
                    }),
                    _: 2
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormControl, null, {
                    default: withCtx((_2, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_Textarea, mergeProps(componentField, {
                          placeholder: "Type your message here",
                          class: "min-h-[120px]"
                        }), null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_Textarea, mergeProps(componentField, {
                            placeholder: "Type your message here",
                            class: "min-h-[120px]"
                          }), null, 16)
                        ];
                      }
                    }),
                    _: 2
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormDescription, null, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_FormMessage, null, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_FormLabel, null, {
                      default: withCtx(() => [
                        createTextVNode(" Message* ")
                      ]),
                      _: 1
                    }),
                    createVNode(_component_FormControl, null, {
                      default: withCtx(() => [
                        createVNode(_component_Textarea, mergeProps(componentField, {
                          placeholder: "Type your message here",
                          class: "min-h-[120px]"
                        }), null, 16)
                      ]),
                      _: 2
                    }, 1024),
                    createVNode(_component_FormDescription),
                    createVNode(_component_FormMessage)
                  ];
                }
              }),
              _: 2
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_FormItem, null, {
                default: withCtx(() => [
                  createVNode(_component_FormLabel, null, {
                    default: withCtx(() => [
                      createTextVNode(" Message* ")
                    ]),
                    _: 1
                  }),
                  createVNode(_component_FormControl, null, {
                    default: withCtx(() => [
                      createVNode(_component_Textarea, mergeProps(componentField, {
                        placeholder: "Type your message here",
                        class: "min-h-[120px]"
                      }), null, 16)
                    ]),
                    _: 2
                  }, 1024),
                  createVNode(_component_FormDescription),
                  createVNode(_component_FormMessage)
                ]),
                _: 2
              }, 1024)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Button, {
        size: "lg",
        class: "w-full"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(` Send Message `);
          } else {
            return [
              createTextVNode(" Send Message ")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</form></div>`);
    };
  }
});
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/contact/form.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const __nuxt_component_0 = Object.assign(_sfc_main$2, { __name: "ContactForm" });
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  __name: "information",
  __ssrInlineRender: true,
  setup(__props) {
    const information = [
      {
        label: "Head Office",
        value: "1 Awe St, Ojodu, Lagos 101232, Lagos.",
        icon: MapPin
      },
      {
        label: "Email",
        value: "support@leenkonnect.com",
        icon: Mail
      },
      {
        label: "Phone",
        value: ["+2347069973395", "+2348073467445"],
        icon: Phone
      },
      {
        label: "Hours",
        value: ["Monday - Friday: 9:00 AM - 8:00 PM", "Saturday - Sunday: 8:00 AM - 9:00 PM"],
        icon: Clock
      }
    ];
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "space-y-8" }, _attrs))}><div class="bg-white rounded-2xl p-8 shadow-soft"><h3 class="font-playfair text-2xl font-semibold text-foreground mb-6"> Visit us </h3><div class="space-y-6"><!--[-->`);
      ssrRenderList(information, ({ label, value, icon }) => {
        _push(`<div class="flex items-start space-x-4">`);
        ssrRenderVNode(_push, createVNode(resolveDynamicComponent(icon), { class: "w-6 h-6 text-primary mt-1 flex-shrink-0" }, null), _parent);
        _push(`<div><p class="font-inter font-medium text-foreground">${ssrInterpolate(label)}</p>`);
        if (typeof value === "string") {
          _push(`<p class="font-inter text-muted-foreground">${ssrInterpolate(value)}</p>`);
        } else {
          _push(`<!--[-->`);
          ssrRenderList(value, (item) => {
            _push(`<p class="font-inter text-muted-foreground">${ssrInterpolate(item)}</p>`);
          });
          _push(`<!--]-->`);
        }
        _push(`</div></div>`);
      });
      _push(`<!--]--></div></div><iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3963.035940157807!2d3.3319874737288018!3d6.642459193352099!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x103b91575a8aaba1%3A0x7288867b59af063!2s1%20Awe%20St%2C%20Ojodu%2C%20Lagos%20101232%2C%20Lagos!5e0!3m2!1sen!2sng!4v1756688616848!5m2!1sen!2sng" class="bg-muted rounded-2xl h-64 w-full flex items-center justify-center" allowfullscreen loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe></div>`);
    };
  }
});
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/contact/information.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const __nuxt_component_1$1 = Object.assign(_sfc_main$1, { __name: "ContactInformation" });
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ContactForm = __nuxt_component_0;
      const _component_ContactInformation = __nuxt_component_1$1;
      _push(`<section${ssrRenderAttrs(mergeProps({ class: "container mx-auto px-4" }, _attrs))}><div class="grid grid-cols-1 lg:grid-cols-2 gap-12 max-w-6xl mx-auto">`);
      _push(ssrRenderComponent(_component_ContactForm, null, null, _parent));
      _push(ssrRenderComponent(_component_ContactInformation, null, null, _parent));
      _push(`</div></section>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/contact/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_1 = Object.assign(_sfc_main, { __name: "Contact" });

export { __nuxt_component_1 as _ };
//# sourceMappingURL=index-DtwdTvU_.mjs.map
